<?php
header('Content-type: application/json');

//error_reporting(E_ALL);

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('This file cannot be accessed directly!');
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$order_id = isset($_GET['order_id']) ? (int) $_GET['order_id'] : 0;

if ($vendor_id === null || $order_id === 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid vendor or order ID']);
    exit;
}

$order_details = $dashboard->getVendorOrderDetails($vendor_id, $order_id);

if (empty($order_details)) {
    echo json_encode(['success' => false, 'message' => 'Order not found']);
    exit;
}

// Format response to match modal expectations
$response = [
    'success' => true,
    'items' => array_map(function ($item) {
        return [
            'name' => $item['product_name'],
            'sku' => $item['product_sku'],
            'quantity' => $item['quantity'],
            'price' => $item['unit_price'],
            'line_total' => $item['line_total']
        ];
    }, $order_details['items']),
    'subtotal' => $order_details['order']['subtotal_amount'],
    'shipping' => $order_details['order']['shipping_amount'],
    'tax' => $order_details['order']['tax_amount'],
    'total' => $order_details['order']['subtotal_amount'] + $order_details['order']['tax_amount'] + $order_details['order']['shipping_amount'] - ($order_details['order']['discount_amount'] ?? 0),
    'discount' => $order_details['order']['discount_amount'] ?? 0,
    'customer_name' => $order_details['customer']['name'],
    'customer_email' => $order_details['customer']['email'],
    'customer_phone' => $order_details['customer']['phone'],
    'customer_address' => $order_details['customer']['address'],
    'status' => $order_details['order']['status'],
    'created_at' => date('Y-m-d H:i', strtotime($order_details['order']['created_at']))
];

echo json_encode($response);
exit;