<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new AdminDashboard($db);

if ($action == 'totalCust') :
    echo json_encode(totalCust($ad, $location));
elseif ($action == 'newCust') :
    echo json_encode(newCust($ad, $duration));
elseif ($action == 'serviceRenewal') :
    echo json_encode(renewals($ad, $duration));
elseif ($action == 'expiringCust') :
    echo json_encode(expiring($ad));
elseif ($action == 'expiredCust') :
    echo json_encode(expired($ad));
elseif ($action == 'freeCust') :
     echo json_encode(freeCust($ad));
endif;

function totalCust($ad, $loc) {
    $location = $loc<>'all'? $loc : '';
    $totalCust = $ad->getTotalCustomers($location);
    $onlineCust = $ad->getOnlineCustomers($location);
    $activeCust = $ad->getActiveCustomers($location);
    $expiredCust = $ad->getExpiredCustomers($location);
    $pausedCust = $ad->getPausedCustomers($location);
    $pendingCust = $ad->getPendingCustomers($location);
    return ["status"=>1, "totalCust"=>($totalCust), "onlineCust"=>($onlineCust), 
                "activeCust"=>($activeCust), "expiredCust"=>($expiredCust), 
                "pausedCust"=>($pausedCust), "pendingCust"=>($pendingCust)];
}

function newCust($ad, $dur) {
    $startDate = $endDate = "";
    if ($dur == "thisMonth"):
        $startDate = date('Y-m-d', strtotime('first day of this month'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastMonth") :
        $startDate = date('Y-m-d', strtotime('first day of last month'));
        $endDate = date('Y-m-d', strtotime('last day of last month'));
    elseif ($dur == "twoMonthAgo") :
        $startDate = date('Y-m-01', strtotime('-2 months'));
        $endDate = date('Y-m-t', strtotime('-2 months'));
    elseif ($dur == "last3Months") :
        $startDate = date('Y-m-01', strtotime('-3 months'));
        $endDate = date('Y-m-t', strtotime('-3 months'));
    elseif ($dur == "last6Months") :
        $startDate = date('Y-m-01', strtotime('-6 months'));
        $endDate = date('Y-m-t', strtotime('-6 months'));
    elseif ($dur == "thisYear") :
        $startDate = date('Y-m-d', strtotime('first day of January this year'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastYear") :
        $startDate = date('Y-m-d', strtotime('first day of January last year'));
        $endDate = date('Y-m-d', strtotime('last day of December last year'));
    elseif (is_int((int)$dur)) :
        $startDate = date('Y-m-d', strtotime("-".$dur." days"));
        $endDate = date('Y-m-d');
    endif;
    $resp = $ad->getNewActivationsByLocation($startDate, $endDate);
    $total = array_sum($resp);
    
    return ["status"=>1, "total"=>$total, "Lagos"=>$resp["Lagos"], "Abuja"=>$resp["Abuja"], 
            "PH"=>$resp["Port Harcourt"], "Ilorin"=>$resp["Ilorin"]];
}

function renewals($ad, $dur) {
    $startDate = $endDate = "";
    if ($dur == "thisMonth"):
        $startDate = date('Y-m-d', strtotime('first day of this month'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastMonth") :
        $startDate = date('Y-m-d', strtotime('first day of last month'));
        $endDate = date('Y-m-d', strtotime('last day of last month'));
    elseif ($dur == "twoMonthAgo") :
        $startDate = date('Y-m-01', strtotime('-2 months'));
        $endDate = date('Y-m-t', strtotime('-2 months'));
    elseif ($dur == "last3Months") :
        $startDate = date('Y-m-01', strtotime('-3 months'));
        $endDate = date('Y-m-t', strtotime('-3 months'));
    elseif ($dur == "last6Months") :
        $startDate = date('Y-m-01', strtotime('-6 months'));
        $endDate = date('Y-m-t', strtotime('-6 months'));
    elseif ($dur == "thisYear") :
        $startDate = date('Y-m-d', strtotime('first day of January this year'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastYear") :
        $startDate = date('Y-m-d', strtotime('first day of January last year'));
        $endDate = date('Y-m-d', strtotime('last day of December last year'));
    elseif (is_int((int)$dur)) :
        $startDate = date('Y-m-d', strtotime("-".$dur." days"));
        $endDate = date('Y-m-d');
    endif;
    $resp = $ad->getRenewalTransactions($startDate, $endDate);
    
    $ret = ["status"=>1, "totalAmt"=>0, "totalTranx"=>0];
    foreach ($resp as $key=>$value) {
        $ret['totalAmt'] += $value['sales']; 
        $ret['totalTranx'] += $value['nTrans'];
        $k = ($key == "Port Harcourt")? "PH" : $key;
        $ret[$k] = $value;
    }
    
    return $ret;
}

function expiring($ad) {
    $respToday = $ad->getExpiringByDate(date("Y-m-d"));
    $respTomorrow = $ad->getExpiringByDate(date("Y-m-d", strtotime("+1 days")));
    $respIn10 = $ad->getExpiringInDays(10);
    
    $ret = ["status"=>1];
    foreach ($respToday as $key=>$value) {
        $k = ($key == "Port Harcourt")? "PH" : $key;
        $ret["expiringToday".$k] = $value;
        $ret["expiringTomorrow".$k] = $respTomorrow[$key];
        $ret["expiringIn10".$k] = $respIn10[$key];
    }
    
    return $ret;
}

function expired_old($ad) {
    $respLTE30 = $ad->getExpiredCustomers('', "0-30", 0, '', 1);
    $resp31To89 = $ad->getExpiredCustomers('', "31-89", 0, '', 1);
    $respGTE90 = $ad->getExpiredCustomers('', "Churn", 0, '', 1);
    
    $ret = ["status"=>1, "expiredTotal"=>0];
    foreach ($respLTE30 as $key=>$value) {
        $k = ($key == "Port Harcourt")? "PH" : $key;
        $ret["expiredLTE30".$k] = $value;
        $ret["expired31To89".$k] = $resp31To89[$key];
        $ret["expiredGTE90".$k] = $respGTE90[$key];
        $ret["expiredTotal".$k] = $value + $resp31To89[$key] + $respGTE90[$key];
        
        $ret["expiredTotal"] += $value + $resp31To89[$key] + $respGTE90[$key];
    }
    
    return $ret;
}

function expired($ad) {
    $table = '__expiry1';
    if ($ad->__createTempExpiryTable($table)):
        $respLTE30 = $ad->getExpiredCustomersFromTable($table, '', "0-30", 0, '', 1);
        $resp31To89 = $ad->getExpiredCustomersFromTable($table, '', "31-89", 0, '', 1);
        $respGTE90 = $ad->getExpiredCustomersFromTable($table, '', "Churn", 0, '', 1);

        $ret = ["status"=>1, "expiredTotal"=>0];
        foreach ($respLTE30 as $key=>$value) {
            $k = ($key == "Port Harcourt")? "PH" : $key;
            $ret["expiredLTE30".$k] = $value;
            $ret["expired31To89".$k] = $resp31To89[$key];
            $ret["expiredGTE90".$k] = $respGTE90[$key];
            $ret["expiredTotal".$k] = $value + $resp31To89[$key] + $respGTE90[$key];

            $ret["expiredTotal"] += $value + $resp31To89[$key] + $respGTE90[$key];
        }
        $ad->__destroyTempTable($table);
        return $ret;
    endif;
    
    return ["status"=>0];
}

function freeCust($ad) {
    $table = '__expiry2';
    if ($ad->__createTempExpiryTable($table)):
        $respActiveStaff = $ad->getActiveCustomers('', 1, 'S', 1);
        $respExpiredStaff = $ad->getExpiredCustomersFromTable($table, '', "", 1, 'S', 1);
        $respActiveFnF = $ad->getActiveCustomers('', 1, 'C', 1);
        $respExpiredFnF = $ad->getExpiredCustomersFromTable($table, '', "", 1, 'C', 1);

        $ret = ["status"=>1, "freeTotal"=>0];
        foreach ($respActiveStaff as $key=>$value) {
            $k = ($key == "Port Harcourt")? "PH" : $key;
            $ret["activeStaff".$k] = $value;
            $ret["expiredStaff".$k] = $respExpiredStaff[$key];
            $ret["activeFnF".$k] = $respActiveFnF[$key];
            $ret["expiredFnF".$k] = $respExpiredFnF[$key];

            $ret["freeTotal"] += $value + $respExpiredStaff[$key] + $respActiveFnF[$key] + $respExpiredFnF[$key];
        }
        $ad->__destroyTempTable($table);
        return $ret;
    endif;
    
    return ["status"=>0];
}

function freeCust_old($ad) {
    $respActiveStaff = $ad->getActiveCustomers('', 1, 'S', 1);
    $respExpiredStaff = $ad->getExpiredCustomers('', "", 1, 'S', 1);
    $respActiveFnF = $ad->getActiveCustomers('', 1, 'C', 1);
    $respExpiredFnF = $ad->getExpiredCustomers('', "", 1, 'C', 1);
    
    $ret = ["status"=>1, "freeTotal"=>0];
    foreach ($respActiveStaff as $key=>$value) {
        $k = ($key == "Port Harcourt")? "PH" : $key;
        $ret["activeStaff".$k] = $value;
        $ret["expiredStaff".$k] = $respExpiredStaff[$key];
        $ret["activeFnF".$k] = $respActiveFnF[$key];
        $ret["expiredFnF".$k] = $respExpiredFnF[$key];
        
        $ret["freeTotal"] += $value + $respExpiredStaff[$key] + $respActiveFnF[$key] + $respExpiredFnF[$key];
    }
    
    return $ret;
}