<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    http_response_code(403);
    echo json_encode(['error' => 'This file cannot be accessed directly!']);
    exit;
}

try {
    $db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
    $db->set_charset("utf8");

    $dashboard = new MarketplaceDashboard($db);

    // Check if this is an export request
    if (isset($_GET['action']) && $_GET['action'] === 'export') {
        $search = isset($_GET['search']) ? trim($_GET['search']) : null;
        $status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
        $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
        $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

        // Fetch all vendors for export
        $vendorsData = $dashboard->getVendorsPaginated(1, 0, $search, $status, $startDate, $endDate, true);
        $vendors = $vendorsData['vendors'];

        // Format data for export
        $data = [];
        foreach ($vendors as $vendor) {
            $status = strtolower($vendor->status ?: 'pending');
            $data[] = [
                'business_name' => $vendor->business_name,
                'email' => $vendor->email,
                'type' => $vendor->type ?: 'N/A',
                'status' => ucfirst($status),
                'phone' => $vendor->bank_account ?: 'N/A',
                'created_at' => date('Y-m-d h:i A', strtotime($vendor->created_at))
            ];
        }

        echo json_encode(['data' => $data]);
        exit;
    }

    // DataTables request
    $draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
    $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
    $limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    // Fetch paginated vendors
    $vendorsData = $dashboard->getVendorsPaginated($page, $limit, $search, $status, $startDate, $endDate);
    $vendors = $vendorsData['vendors'];
    $totalRecords = $vendorsData['totalRecords'];
    $filteredRecords = $vendorsData['filteredRecords'];

    // Format data for DataTables
    $data = [];
    foreach ($vendors as $vendor) {
        $status = strtolower($vendor->status ?: 'pending');
        $avatarInitials = strtoupper(substr($vendor->business_name, 0, 2));
        $data[] = [
            'business_name' => '
                <div class="vendor-info">
                    <input type="checkbox" class="vendor-checkbox" />
                    <div class="vendor-avatar">' . htmlspecialchars($avatarInitials) . '</div>
                    <div class="vendor-details">
                        <h6>' . htmlspecialchars($vendor->business_name) . '</h6>
                        <p>' . htmlspecialchars($vendor->email) . '</p>
                    </div>
                </div>',
            'type' => '<span class="vendor-type">' . htmlspecialchars($vendor->type ?: 'N/A') . '</span>',
            'status' => '<span class="status-badge status-' . htmlspecialchars($status) . '">' . htmlspecialchars(ucfirst($status)) . '</span>',
            'phone' => '<span class="vendor-phone">' . htmlspecialchars($vendor->bank_account ?: 'N/A') . '</span>',
            'created_at' => '<span class="vendor-date">' . htmlspecialchars(date('Y-m-d h:i A', strtotime($vendor->created_at))) . '</span>',
            'actions' => $status === 'restricted' ?
                '<button class="actions-btn" onclick="showUnrestrictModal(' . $vendor->id . ', \'' . htmlspecialchars($vendor->business_name) . '\')"><i class="fa fa-lock"></i></button>' :
                '<button class="view-btn" onclick="viewVendor(' . $vendor->id . ')"><i class="fa fa-eye"></i></button>'
        ];
    }

    // Return DataTables JSON response
    echo json_encode([
        'draw' => $draw,
        'recordsTotal' => $totalRecords,
        'recordsFiltered' => $filteredRecords,
        'data' => $data
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
    exit;
}