<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    echo json_encode(['error' => 'This file cannot be accessed directly!']);
    exit;
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);

// Check if vendor_id is valid
if ($vendor_id === null) {
    echo json_encode([
        'draw' => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
        'recordsTotal' => 0,
        'recordsFiltered' => 0,
        'data' => []
    ]);
    exit;
}

// Check if this is an export request
if (isset($_GET['action']) && $_GET['action'] === 'export') {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    $salesData = $dashboard->getVendorOrders($vendor_id, 1, 0, $search, 'fulfilled', $startDate, $endDate, true);
    $sales = $salesData['orders'];

    $data = [];
    foreach ($sales as $sale) {
        $data[] = [
            'order_id' => $sale->order_id,
            'customer_name' => $sale->customer_name,
            'email' => $sale->customer_email,
            'product' => $sale->product_names ?? 'N/A',
            'status' => 'Fulfilled',
            'price' => '₦' . number_format($sale->total_amount, 2),
            'date' => date('Y-m-d h:i A', strtotime($sale->created_at))
        ];
    }

    echo json_encode(['data' => $data]);
    exit;
}

// DataTables request
$draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 5;
$search = isset($_GET['search']) ? trim($_GET['search']) : null;
$startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
$endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

// Fetch paginated sales
$salesData = $dashboard->getVendorOrders($vendor_id, $page, $limit, $search, 'fulfilled', $startDate, $endDate);
$sales = $salesData['orders'];
$totalRecords = $salesData['totalRecords'];
$filteredRecords = $salesData['filteredRecords'];

$avatarColors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];

// Format data for DataTables
$data = [];
foreach ($sales as $index => $sale) {
    $avatarColor = $avatarColors[$index % count($avatarColors)];
    $avatarInitials = strtoupper(substr($sale->customer_name, 0, 1) . (strpos($sale->customer_name, ' ') !== false ? substr($sale->customer_name, strpos($sale->customer_name, ' ') + 1, 1) : ''));

    $data[] = [
        'order_id' => htmlspecialchars($sale->order_id),
        'customer_name' => htmlspecialchars($sale->customer_name),
        'email' => htmlspecialchars($sale->customer_email),
        'product' => htmlspecialchars($sale->product_name ?? 'N/A'),
        'status' => '<span class="label" style="background: #4caf50;">Fulfilled</span>',
        'price' => '₦' . number_format($sale->total_amount, 2),
        'date' => date('Y-m-d h:i A', strtotime($sale->created_at)),
        'customer' => '
            <div style="display: flex; align-items: center; gap: 12px;">
                <input type="checkbox" class="sales-checkbox" />
                <div class="customer-info">
                    <div class="customer-avatar ' . $avatarColor . '">' . htmlspecialchars($avatarInitials) . '</div>
                    <div class="customer-details">
                        <h6>' . htmlspecialchars($sale->customer_name) . '</h6>
                        <p>' . htmlspecialchars($sale->customer_email) . '</p>
                    </div>
                </div>'
    ];
}

echo json_encode([
    'draw' => $draw,
    'recordsTotal' => $totalRecords,
    'recordsFiltered' => $filteredRecords,
    'data' => $data
]);