<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    echo json_encode(['error' => 'This file cannot be accessed directly!']);
    exit;
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);

// Check if vendor_id is valid
if ($vendor_id === null) {
    echo json_encode([
        'draw' => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
        'recordsTotal' => 0,
        'recordsFiltered' => 0,
        'data' => []
    ]);
    exit;
}

// Check if this is an export request
if (isset($_GET['action']) && $_GET['action'] === 'export') {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $status = isset($_GET['status']) ? trim($_GET['status']) : null;
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    $productsData = $dashboard->getVendorProductPaginated($vendor_id, 1, 0, $search, $status, $startDate, $endDate, true);
    $products = $productsData['products'];

    $data = [];
    foreach ($products as $product) {
        $data[] = [
            'product_id' => $product->product_id,
            'product_name' => $product->product_name,
            'status' => ucfirst($product->product_status),
            'revenue' => '₦' . number_format($product->total_amount_sold, 2),
            'total_sales' => $product->number_of_sales,
            'created_at' => $product->product_created_date
        ];
    }

    echo json_encode(['data' => $data]);
    exit;
}

// DataTables request
$draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : null;
$status = isset($_GET['status']) ? trim($_GET['status']) : null;
$startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
$endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

// Fetch paginated products
$productsData = $dashboard->getVendorProductPaginated($vendor_id, $page, $limit, $search, $status, $startDate, $endDate);
$products = $productsData['products'];
$totalRecords = $productsData['totalRecords'];
$filteredRecords = $productsData['filteredRecords'];

$data = [];
foreach ($products as $product) {
    $statusClass = $product->product_status === 'active' ? 'status-active' : ($product->product_status === 'pending' ? 'status-pending' : ($product->product_status === 'rejected' ? 'status-rejected' : 'status-archived'));

    $dropdownActions = '
        <p class="actions-header">Actions</p>
       <a href="vendor_product_detail.php?id=' . urlencode(base64_encode($product->product_id)) . '" class="edit-btn">Edit</a>
                    <a href="#" class="add-stock-btn" data-product-id="' . htmlspecialchars($product->product_id) . '" data-product-name="' . htmlspecialchars($product->product_name) . '">Add Stock</a>';
    if ($statusClass === 'status-archived') {
        $dropdownActions .= '<a href="#" class="submit-for-review" data-product-id="' . htmlspecialchars($product->product_id) . '" data-product-name="' . htmlspecialchars($product->product_name) . '">Submit for Review</a>';
    }


    $data[] = [
        'product_id' => htmlspecialchars($product->product_id),
        'product_name' => htmlspecialchars($product->product_name),
        'status' => '<span class="status-label ' . $statusClass . '">' . ucfirst(htmlspecialchars($product->product_status)) . '</span>',
        'revenue' => '₦' . number_format($product->total_amount_sold, 2),
        'total_sales' => number_format($product->number_of_sales),
        'created_at' => htmlspecialchars($product->product_created_date),
        'name' => '
            <div style="display: flex; align-items: center">
                <input type="checkbox" class="product-checkbox" style="margin-right: 15px" />
                <div style="width: 40px; height: 40px; background: #e9ecef; border-radius: 6px; margin-right: 15px;"></div>
                <a href="vendor_product_detail.php?id=' . urlencode(base64_encode($product->product_id)) . '" class="product-link">' . htmlspecialchars($product->product_name) . '</a>
            </div>',
        'actions' => '
            <div class="action-container">
                <button class="action-btn"><i class="fa fa-ellipsis-h"></i></button>
                <div class="itemdropdown">' . $dropdownActions . '</div>
            </div>'
    ];
}

echo json_encode([
    'draw' => $draw,
    'recordsTotal' => $totalRecords,
    'recordsFiltered' => $filteredRecords,
    'data' => $data
]);
