<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('Requested file does not exist!');
}
header('Content-Type: application/json');
$tracking_id = $_GET['tracking_id'] ?? $_POST['tracking_id'] ?? null;
if (empty($tracking_id)) {
    echo json_encode([
        'error' => true,
        'message' => 'Missing tracking_id parameter.'
    ]);
    exit;
}

if (!preg_match('/^SO-\d{8}-\d{6}-\d{4}$/', $tracking_id)) {
    echo json_encode([
        'error' => true,
        'message' => 'Invalid tracking ID format.'
    ]);
    exit;
}

//echo json_encode($data);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$order = $dashboard->getCustomerByTrackingId($tracking_id);
if ($order === null) {
    //http_response_code(404);
    echo json_encode([
        'success' => false,
        'message' => 'No order found for that tracking ID.'
    ]);
    exit;
}

//http_response_code(200);
echo json_encode([
    'success' => true,
    'data' => $order
]);
