<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('This file cannot be accessed directly!');
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);

// Get parameters
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$search = $_GET['search'] ?? null;
$status = $_GET['status'] ?? 'paid';
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;

// Get data
$result = $dashboard->getSalesadminPaid($_SESSION[$sid . 'userid'], $search, $status, $page, $limit);

$data = [];
if (!empty($result['customers'])) {
    foreach ($result['customers'] as $customer) {
        // Determine status badge
        $customerStatus = strtolower($customer['status'] ?? 'pending');
        $statusBadge = '';
        if ($customerStatus === 'paid') {
            $statusBadge = '<span class="badge badge-success">Paid</span>';
        } else if ($customerStatus === 'pending') {
            $statusBadge = '<span class="badge badge-warning">Pending</span>';
        } else {
            $statusBadge = '<span class="badge badge-light">' . ucfirst($customerStatus) . '</span>';
        }

        // Action buttons - add resend link for pending customers
        $actionButtons = '<div class="action-buttons">';
        if ($customerStatus === 'pending') {
            $actionButtons .= '<button class="resend-link-btn" 
                                   onclick="resendPaymentLink(\'' . htmlspecialchars($customer['customer_id']) . '\', this)" 
                                   title="Resend Payment Link">
                                   <i class="fa fa-envelope"></i> Resend Link
                               </button>';
        }
        $actionButtons .= '<a href="order_view.php?id=' . urlencode(base64_encode($customer['order_id'])) . '" 
                           class="view-btn" title="View Order">
                           <i class="fa fa-eye"></i> View
                         </a>';
        $actionButtons .= '</div>';

        $data[] = [
            'customer' => '<div class="customer-info">
                            <span class="customer-name">' . htmlspecialchars($customer['customer_name']) . '</span>
                            <span class="customer-email">' . htmlspecialchars($customer['customer_email']) . '</span>
                          </div>',
            'tracking_id' => '<span class="badge badge-light">' . htmlspecialchars($customer['tracking_id'] ?? '-') . '</span>',
            'sales_order_id' => htmlspecialchars($customer['sales_order_id'] ?? '-'),
            'status' => $statusBadge,
            'total' => '<span style="color: #16a34a; font-weight: 600;">₦' . number_format($customer['total_price'] ?? 0, 2) . '</span>',
            'order_date' => date("M d, Y • h:i A", strtotime($customer['created_at'])),
            'action' => $actionButtons
        ];
    }
}

// Return DataTables format
header('Content-Type: application/json');
echo json_encode([
    'draw' => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
    'recordsTotal' => $result['total_count'] ?? 0,
    'recordsFiltered' => $result['total_count'] ?? 0,
    'data' => $data
]);
