<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('This file cannot be accessed directly!');
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);

// Check if this is an export request
if (isset($_GET['action']) && $_GET['action'] === 'export') {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    // Fetch all products for export
    $productsData = $dashboard->getAllProductsPaginated(1, 0, $search, $status, $startDate, $endDate, true);
    $products = $productsData['products'];

    // Format data for export
    $data = [];
    foreach ($products as $product) {
        $status = strtolower($product->status ?: 'pending');
        $data[] = [
            'vendor_name' => $product->vendor_name,
            'vendor_email' => $product->vendor_email,
            'product_name' => $product->name,
            'status' => ucfirst($status),
            'price' => '₦' . number_format($product->price, 2),
            'created_at' => date('Y-m-d h:i A', strtotime($product->created_at))
        ];
    }

    echo json_encode(['data' => $data]);
    exit;
}

// DataTables request
$draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : null;
$status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
$startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
$endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

// Fetch paginated products
$productsData = $dashboard->getAllProductsPaginated($page, $limit, $search, $status, $startDate, $endDate);
$products = $productsData['products'];
$totalRecords = $productsData['totalRecords'];
$filteredRecords = $productsData['filteredRecords'];

// Format data for DataTables
$data = [];
foreach ($products as $product) {
    $status = strtolower($product->status ?: 'pending');
    $avatarInitials = strtoupper(substr($product->vendor_name, 0, 2));
    $data[] = [
        'vendor_name' => '
            <div class="product-info">
                <input type="checkbox" class="product-checkbox" />
                <div class="product-avatar">' . htmlspecialchars($avatarInitials) . '</div>
                <div class="product-details">
                    <h6>' . htmlspecialchars($product->vendor_name) . '</h6>
                    <p>' . htmlspecialchars($product->vendor_email) . '</p>
                </div>
            </div>',
        'vendor_email' => '<span class="product-email">' . htmlspecialchars($product->vendor_email) . '</span>',
        'product_name' => '<span class="product-name">' . htmlspecialchars($product->name) . '</span>',
        'status' => '<span class="status-badge status-' . htmlspecialchars($status) . '">' . htmlspecialchars(ucfirst($status)) . '</span>',
        'price' => '<span class="product-price">₦' . htmlspecialchars(number_format($product->price, 2)) . '</span>',
        'created_at' => '<span class="product-date">' . htmlspecialchars(date('Y-m-d h:i A', strtotime($product->created_at))) . '</span>',
        'actions' => '<button class="view-btn" onclick="viewProduct(' . $product->id . ')"><i class="fa fa-eye"></i></button>'
    ];
}

// Return DataTables JSON response
echo json_encode([
    'draw' => $draw,
    'recordsTotal' => $totalRecords,
    'recordsFiltered' => $filteredRecords,
    'data' => $data
]);