<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('This file cannot be accessed directly!');
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);

// Get parameters
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$search = $_GET['search'] ?? null;
$status = $_GET['status'] ?? null;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
//return $status;
// Get data
$result = $dashboard->getAllSalesadminCustomers($_SESSION[$sid . 'userid'], $search, $status, $page, $limit);

$data = [];
if (!empty($result['customers'])) {
    foreach ($result['customers'] as $customer) {
        $data[] = [
            'customer' => '<div class="customer-info">
                            <span class="customer-name">' . htmlspecialchars($customer['customer_name']) . '</span>
                            <span class="customer-email">' . htmlspecialchars($customer['customer_email']) . '</span>
                          </div>',
            'status' => '<span class="badge badge-light">' . htmlspecialchars($customer['status'] ?? '-') . '</span>',

            'tracking_id' => '<span class="badge badge-light">' . htmlspecialchars($customer['tracking_id'] ?? '-') . '</span>',
            'sales_order_id' => htmlspecialchars($customer['sales_order_id'] ?? '-'),
            'total' => '<span style="color: #16a34a; font-weight: 600;">₦' . number_format($customer['total_price'] ?? 0, 2) . '</span>',
            'order_date' => date("M d, Y • h:i A", strtotime($customer['order_created_at'])),
            'action' => '<a href="order_view.php?id=' . urlencode(base64_encode($customer['order_id'])) . '" 
                           class="view-btn" title="View Order">
                           <i class="fa fa-eye"></i> View
                         </a>'
        ];
    }
}

// Return DataTables format
header('Content-Type: application/json');
echo json_encode([
    'draw' => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
    'recordsTotal' => $result['total_count'] ?? 0,
    'recordsFiltered' => $result['total_count'] ?? 0,
    'data' => $data,
]);
