<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$adminUser = $_SESSION[$sid.'username'];
if ($adminUser != $user) :
    echo "Error: Unauthorized Access";
    exit();
endif;
$log = new Logger($db, $adminUser);
$ad = new UserProfile($db);
if ($sendTo == "all") :
    $criteria = [];
elseif ($sendTo == "sel") :
    $criteria = $musers;
elseif ($sendTo == "upload") :
    $userlist = explode(",", $selusers);
    $criteria = $userlist;
elseif ($sendTo == "olt") :
    $criteria = $molt;
    $olt = join(",",$criteria);
elseif ($sendTo == "gpon") :
    $criteria = $mgpon;
    $gpon = join(",",$criteria);
else:
    echo "Error: Invalid Operation"; 
    exit();
endif; 

$contacts = $ad->getUserContact($sendTo, $criteria);
//Check if email exist
if (count($contacts) < 1):
    echo "Error: Record Missing; cannot extend accounts";
    exit();
endif;
$recipient = array_column($contacts, 'USERNAME');
$affected = json_encode($recipient);
$creationDate = date("Y-m-d H:i:s");

$pass = new Password_Generator();
$ticketId = "LOSS-" . $pass->generate(8, 13, TRUE);

$cticket = $ad->createOutageTicket($ticketId, 'Down Time', $olt, $gpon, $affected, $creationDate, $creationDate, 
            "Open", $reason, $adminUser, $creationDate);

if ($cticket) {
    //close ticket
    $close = $ad->closeLossDaysTicket($ticketId, $cticket, $duration, 'Closed', 1, 1, $admin);
    //Request Loss Days
    $ret = $ad->requestLostDays($ticketId, $cticket, $duration, $adminUser);
    
//    @TODO   send email
    //Get Message
    $ttck = base64_encode($ticketId);
    $iincid = base64_encode($cticket);
    $ddays = base64_encode($duration);
    $raw_msg = $ad->getCannedMessage("LOST_DAYS_APPROVAL_REQUEST");
    $apprroveURL = SERVER_URL . "appLossDays?t=$ttck&i=$iincid&dd=$ddays";
    $disapprroveURL = SERVER_URL . "disappLossDays?t=$ttck&i=$iincid";
    
    $msg = sprintf($raw_msg, $_SESSION[$sid.'fullname'], $duration*1, $affected, $reason, $apprroveURL, $apprroveURL,$disapprroveURL,$disapprroveURL);

    $sent = $ad->sendEmail("femi.adeyemi@fob.ng", EMAIL_SENDER, "FiberOne - Pending Loss Days Request", $msg);
    
    //return
    echo "Success: Loss Days Request created";
} else {
    echo "Error: Unable to create the loss days request";
}