<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../includes/AddressCoverage.php"; // Make sure this path is correct

// Only allow AJAX requests
if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest')) {
    die(json_encode(['error' => 'This file cannot be accessed directly!']));
}
// Get the address from POST
$address = filter_var($_POST['address'] ?? '', FILTER_SANITIZE_STRING);

if (empty($address)) {
    echo json_encode([
        'success' => false,
        'error' => 'No address provided.'
    ]);
    exit;
}
//$address = "";
$ad = new AddressCoverage();

$addresses = $ad->checkAddress($address);

echo json_encode([
    'success' => true,
    'data' => $addresses
]);
