<?php
ob_start(); // Start output buffering to prevent unwanted HTML output
$page = "Admin Vendor Products";
$page_url = "admin_vendor_product";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

// Redirect if not admin
if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)) {
    ob_end_clean();
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?php
    exit();
}

// Validate vendor ID
if (!isset($_GET['id'])) {
    ob_end_clean();
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
}

$vendorId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($vendorId)) {
    ob_end_clean();
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
}

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$allproducts = $dashboard->getVendorProductsPaginated(
    $vendorId,
    $_GET['page'] ?? 1,
    12, // Increased to 12 for better grid layout
    $_GET['search'] ?? null
);
$vendor = $dashboard->getVendorDetails($vendorId); // Get vendor details for display
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>

<!-- Include Dependencies -->
<link rel="stylesheet" href="http://localhost/eservice/bower_components/bootstrap/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="http://localhost/eservice/bower_components/font-awesome/css/font-awesome.min.css">
<script src="http://localhost/eservice/bower_components/jquery/dist/jquery.min.js"></script>
<script src="http://localhost/eservice/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

<style>
    .main-content {
        margin-left: 230px;
        background-color: white;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .search-form {
        margin-bottom: 20px;
        display: flex;
        gap: 10px;
        align-items: center;
    }

    .search-form input[type="text"] {
        flex: 1;
        max-width: 300px;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
        position: relative;
    }

    .search-form .search-icon {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .search-form button {
        padding: 8px 16px;
        border: none;
        background: #2c5aa0;
        color: white;
        border-radius: 4px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
    }

    .search-form button:hover {
        background: #1a3c6c;
    }

    .search-form .reset-btn {
        padding: 8px 16px;
        background: #6c757d;
        color: white;
        border-radius: 4px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
    }

    .search-form .reset-btn:hover {
        background: #5a6268;
    }

    .info-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        overflow: hidden;
    }

    .card-header {
        background-color: #f8f9fa;
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-bottom: 1px solid #e9ecef;
        font-weight: 600;
        color: #333;
    }

    .card-body {
        padding: 20px;
    }

    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }

    .product-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        padding: 15px;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        display: flex;
        flex-direction: column;
    }

    .product-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }

    .product-card img {
        width: 100%;
        height: 150px;
        object-fit: cover;
        border-radius: 6px;
        margin-bottom: 10px;
    }

    .product-card h3 {
        margin: 0 0 10px;
        color: #333;
        font-size: 18px;
        font-weight: 600;
    }

    .product-card .price {
        font-weight: bold;
        color: #27ae60;
        margin-bottom: 8px;
        font-size: 16px;
    }

    .product-card .status {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
        margin-bottom: 8px;
    }

    .product-card .status.active {
        background-color: #28a745;
    }

    .product-card .status.inactive {
        background-color: #e67e22;
    }

    .product-card .status.archived {
        background-color: #dc3545;
    }

    .product-card .dates {
        font-size: 12px;
        color: #888;
        line-height: 1.4;
        margin-bottom: 10px;
    }

    .product-card .view-btn {
        margin-top: auto;
        padding: 6px 12px;
        background: #2c5aa0;
        color: white;
        border-radius: 4px;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        text-align: center;
    }

    .product-card .view-btn:hover {
        background: #1a3c6c;
    }

    .no-products {
        grid-column: 1 / -1;
        text-align: center;
        padding: 20px;
        color: #666;
        background: #f8f9fa;
        border-radius: 8px;
        font-size: 16px;
    }

    .pagination {
        margin-top: 20px;
        text-align: center;
    }

    .pagination a,
    .pagination span {
        display: inline-block;
        padding: 8px 12px;
        margin: 0 3px;
        border: 1px solid #ddd;
        border-radius: 4px;
        text-decoration: none;
        color: #2c5aa0;
        font-size: 14px;
    }

    .pagination .active {
        background: #2c5aa0;
        color: white;
        border-color: #2c5aa0;
        font-weight: 500;
    }

    .pagination a:hover {
        background: #f8f9fa;
        border-color: #2c5aa0;
    }

    .alert {
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-dismissible .close {
        position: absolute;
        top: 0;
        right: 10px;
        padding: 10px;
        color: inherit;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
            padding: 15px;
        }

        .content-area {
            padding: 0 15px 15px;
        }

        .search-form {
            flex-direction: column;
            align-items: stretch;
        }

        .search-form input[type="text"] {
            max-width: none;
        }

        .products-grid {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 576px) {

        .search-form button,
        .search-form .reset-btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Vendor Products - <?= htmlspecialchars($vendor->business_name ?? 'Unknown Vendor') ?>
        </h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="navigateTo('vendors')">Vendors</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="navigateTo('vendor_detail', '<?= urlencode(base64_encode($vendorId)) ?>')">Vendor
                Details</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Vendor Products</span>
        </nav>

        <!-- Products Section -->
        <?php if ($allproducts): ?>
            <div class="info-card">
                <div class="card-header">
                    <div>
                        <p>Vendor Products</p>
                        <p class="date-badge">
                            Vendor: <?= htmlspecialchars($vendor->business_name ?? $allproducts->vendor->name) ?> |
                            Total Products: <strong><?= $allproducts->total_products ?></strong>
                        </p>
                    </div>
                </div>
                <div class="card-body">
                    <form method="get" action="" class="search-form">
                        <input type="hidden" name="id" value="<?= htmlspecialchars($_GET['id']) ?>">
                        <div style="position: relative;">
                            <input type="text" name="search" placeholder="Search products by name or status..."
                                value="<?= htmlspecialchars($allproducts->search ?? '') ?>">
                            <i class="fa fa-search search-icon"></i>
                        </div>
                        <button type="submit">Search</button>
                        <?php if (!empty($allproducts->search)): ?>
                            <a href="?id=<?= urlencode($_GET['id']) ?>" class="reset-btn">Reset</a>
                        <?php endif; ?>
                    </form>

                    <!-- Products Grid -->
                    <div class="products-grid">
                        <?php if (!empty($allproducts->products)): ?>
                            <?php foreach ($allproducts->products as $product): ?>
                                <div class="product-card">
                                    <img src="<?= htmlspecialchars($product->image ?? 'https://via.placeholder.com/150?text=Product+Image') ?>"
                                        alt="Product Image">
                                    <h3><?= htmlspecialchars($product->name) ?></h3>
                                    <p class="price">&#8358;<?= number_format($product->price, 2) ?></p>
                                    <p class="status <?= strtolower($product->status) ?>">
                                        Status: <?= ucfirst($product->status) ?>
                                    </p>
                                    <p class="dates">
                                        Created: <?= htmlspecialchars($product->created_at) ?><br>
                                        Updated: <?= htmlspecialchars($product->updated_at) ?>
                                    </p>
                                    <a href="product_detail.php?id=<?= urlencode(base64_encode($product->id)) ?>"
                                        class="view-btn">View Product</a>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="no-products">
                                <?php if (!empty($allproducts->search)): ?>
                                    <p>No products found for "<strong><?= htmlspecialchars($allproducts->search) ?></strong>".</p>
                                <?php else: ?>
                                    <p>This vendor has no products yet.</p>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Pagination -->
                    <?php if ($allproducts->totalPages > 1): ?>
                        <div class="pagination">
                            <?php
                            $currentPage = $allproducts->currentPage;
                            $searchQuery = !empty($allproducts->search) ? "&search=" . urlencode($allproducts->search) : "";
                            $vendorParam = "id=" . urlencode($_GET['id']);
                            ?>
                            <?php if ($currentPage > 1): ?>
                                <a href="?<?= $vendorParam ?>&page=<?= $currentPage - 1 ?><?= $searchQuery ?>">« Prev</a>
                            <?php endif; ?>
                            <?php for ($i = 1; $i <= $allproducts->totalPages; $i++): ?>
                                <?php if ($i == $currentPage): ?>
                                    <span class="active"><?= $i ?></span>
                                <?php else: ?>
                                    <a href="?<?= $vendorParam ?>&page=<?= $i ?><?= $searchQuery ?>"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor; ?>
                            <?php if ($currentPage < $allproducts->totalPages): ?>
                                <a href="?<?= $vendorParam ?>&page=<?= $currentPage + 1 ?><?= $searchQuery ?>">Next »</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="no-products">
                <p>Vendor not found.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>
<?php ob_end_flush(); ?>

<script>
    // Navigation function
    function navigateTo(page, id = '') {
        if (page === 'dashboard') {
            window.location.href = 'dasha';
        } else if (page === 'vendors') {
            window.location.href = 'vendors';
        } else if (page === 'vendor_detail') {
            window.location.href = `vendor_detail.php?id=${id}`;
        }
    }

    // Notification system (for future error handling)
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible`;
        notification.style.cssText = `
            position: fixed;
            top: 90px;
            right: 20px;
            z-index: 9999;
            min-width: 300px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        `;
        notification.innerHTML = `
            <button type="button" class="close" onclick="this.parentElement.remove()">
                <span>&times;</span>
            </button>
            <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
        `;
        document.body.appendChild(notification);
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 5000);
    }

    // Initialize page
    $(document).ready(function () {
        console.log('Vendor Products initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }

        // Handle responsive behavior
        window.addEventListener('resize', function () {
            if (window.innerWidth <= 768) {
                document.body.classList.add('mobile-view');
            } else {
                document.body.classList.remove('mobile-view');
            }
        });
    });
</script>