<?PHP
$page = "Add Vendors Dashboard";
$page_url = "add_vendor";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';



//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$get_vendor_and_business_types = $dashboard->getVendorAndBusinessTypes($_SESSION[$sid . 'userid']);

$vendorData = $get_vendor_and_business_types['vendor'];
$businessTypes = $get_vendor_and_business_types['business_types'];
$states = $get_vendor_and_business_types['states'];
//print_r($states);
//print_r($businessTypes);
// Fallback to session values if vendor data is missing
$phoneNo = $vendorData['phone_number'] ?? ($_SESSION[$sid . 'phoneNo'] ?? '');
$fullname = $vendorData['name'] ?? ($_SESSION[$sid . 'fullname'] ?? '');
$email = $vendorData['email'] ?? ($_SESSION[$sid . 'email'] ?? '');
$website = $vendorData['website'] ?? '';

//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

//$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid'])); 

//conditional button rendering
$btnText = 'Submit Application';
$btnDisabled = false;

if (!empty($vendorData['global_id'])) {
    // Vendor exists
    $btnText = 'Update';

    if (!empty($vendorData['status']) && in_array($vendorData['status'], ['declined', 'restricted'])) {
        $btnText = strtoupper($vendorData['status']); // DECLINED / RESTRICTED
        $btnDisabled = true;
    }
}
?>

<!-- ?php print_r($paginatedvendors); ? -->

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            Add Vendor
            <small>New Vendor Registration</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Add Vendor</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Vendor Information</h3>
            </div>
            <div class="alert alert-danger" id="errPan" style="display: none"></div>
            <div class="alert alert-success" id="succPan" style="display: none"></div>

            <form id="addVendorForm">
                <div class="box-body">

                    <!-- Full Name (readonly) -->
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" class="form-control" name="name" value="<?= htmlspecialchars($fullname) ?>" readonly>
                    </div>

                    <!-- Email (readonly) -->
                    <div class="form-group">
                        <label for="email">Email *</label>
                        <input type="email" id="email" class="form-control" name="email" value="<?= htmlspecialchars($email) ?>" readonly>
                    </div>

                    <!-- Business Name -->
                    <div class="form-group">
                        <label for="business_name">Business Name *</label>
                        <input type="text" id="business_name" class="form-control" name="business_name" value="<?= htmlspecialchars($vendorData['business_name']) ?>" required>
                    </div>


                    <!-- Business Type -->
                    <div class="form-group">
                        <label for="business_type_id">Business Type *</label>
                        <select id="business_type_id" name="business_type_id" class="form-control" required>
                            <option value="">-- Select Type --</option>
                            <?php foreach ($businessTypes as $bt): ?>
                                <option value="<?= $bt['id'] ?>"
                                    <?= (!empty($vendorData['business_type_id']) && $vendorData['business_type_id'] == $bt['id']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($bt['type_name'] . " - " . $bt['description']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Phone Number (readonly) -->
                    <div class="form-group">
                        <label for="phone_number">Phone Number</label>
                        <input type="text" id="phone_number" class="form-control" name="phone_number" value="<?= htmlspecialchars($phoneNo) ?>" readonly>
                    </div>

                    <!-- Website -->
                    <div class="form-group">
                        <label for="website">Website</label> <input type="text" id="website" class="form-control" name="website" value="<?= htmlspecialchars($website) ?>">

                    </div>

                    <!-- State -->
                    <div class="form-group">
                        <label for="state">Select State *</label>
                        <select id="state" name="state" class="form-control" required>
                            <option value="">-- Select state --</option>
                            <?php foreach ($states as $st): ?>
                                <option value="<?= htmlspecialchars($st['statename']) ?>"
                                    <?= (!empty($vendorData['state']) && $vendorData['state'] == $st['statename']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($st['statename']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- City -->
                    <div class="form-group">
                        <label for="city">City</label>
                        <input type="text" id="city" class="form-control" name="city">
                    </div>

                    <!-- Bio -->
                    <div class="form-group">
                        <label for="bio">Bio</label>
                        <textarea id="bio" class="form-control" name="bio" rows="3"></textarea>
                    </div>

                    <!-- Title -->
                    <div class="form-group">
                        <label for="title">Title</label>
                        <select id="title" class="form-control" name="title">
                            <option value="">-- Select Title --</option>
                            <option value="Mr">Mr</option>
                            <option value="Mrs">Mrs</option>
                            <option value="Miss">Miss</option>
                            <option value="Dr">Dr</option>
                            <option value="Prof">Prof</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>

                </div>

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary" <?= $btnDisabled ? 'disabled' : '' ?>>
                        <?= htmlspecialchars($btnText) ?>
                    </button>
                </div>
            </form>

        </div>
    </section>
</div>

<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script>
    $(document).ready(function() {
        var fadeInFadeOut = function(jQueryElement, timeout) {
            jQueryElement.fadeIn(1000);
            // setTimeout(function() {
            //     jQueryElement.fadeOut("slow");
            // }, timeout);
        };
        var Base64 = {
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
            encode: function(e) {
                var t = "";
                var n, r, i, s, o, u, a;
                var f = 0;
                e = Base64._utf8_encode(e);
                while (f < e.length) {
                    n = e.charCodeAt(f++);
                    r = e.charCodeAt(f++);
                    i = e.charCodeAt(f++);
                    s = n >> 2;
                    o = (n & 3) << 4 | r >> 4;
                    u = (r & 15) << 2 | i >> 6;
                    a = i & 63;
                    if (isNaN(r)) {
                        u = a = 64
                    } else if (isNaN(i)) {
                        a = 64
                    }
                    t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
                }
                return t
            },
            decode: function(e) {
                var t = "";
                var n, r, i;
                var s, o, u, a;
                var f = 0;
                e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "");
                while (f < e.length) {
                    s = this._keyStr.indexOf(e.charAt(f++));
                    o = this._keyStr.indexOf(e.charAt(f++));
                    u = this._keyStr.indexOf(e.charAt(f++));
                    a = this._keyStr.indexOf(e.charAt(f++));
                    n = s << 2 | o >> 4;
                    r = (o & 15) << 4 | u >> 2;
                    i = (u & 3) << 6 | a;
                    t = t + String.fromCharCode(n);
                    if (u != 64) {
                        t = t + String.fromCharCode(r)
                    }
                    if (a != 64) {
                        t = t + String.fromCharCode(i)
                    }
                }
                t = Base64._utf8_decode(t);
                return t
            },
            _utf8_encode: function(e) {
                e = e.replace(/\r\n/g, "\n");
                var t = "";
                for (var n = 0; n < e.length; n++) {
                    var r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r)
                    } else if (r > 127 && r < 2048) {
                        t += String.fromCharCode(r >> 6 | 192);
                        t += String.fromCharCode(r & 63 | 128)
                    } else {
                        t += String.fromCharCode(r >> 12 | 224);
                        t += String.fromCharCode(r >> 6 & 63 | 128);
                        t += String.fromCharCode(r & 63 | 128)
                    }
                }
                return t
            },
            _utf8_decode: function(e) {
                var t = "";
                var n = 0;
                var r = c1 = c2 = 0;
                while (n < e.length) {
                    r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r);
                        n++
                    } else if (r > 191 && r < 224) {
                        c2 = e.charCodeAt(n + 1);
                        t += String.fromCharCode((r & 31) << 6 | c2 & 63);
                        n += 2
                    } else {
                        c2 = e.charCodeAt(n + 1);
                        c3 = e.charCodeAt(n + 2);
                        t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
                        n += 3
                    }
                }
                return t
            }
        }
        $('#addVendorForm').validator().on('submit', function(e) {
            e.preventDefault();

            $('#succPan, #errPan').hide().empty();

            var name = $('#name').val().trim();
            var email = $('#email').val().trim();
            var businessName = $('#business_name').val().trim();
            var businessType = $('#business_type_id').val();

            if (!name) {
                alert('Full Name is required.');
                return;
            }
            if (!email) {
                alert('Email is required.');
                return;
            }
            if (!businessName) {
                alert('Business Name is required.');
                return;
            }
            if (!businessType) {
                alert('Please select a Business Type.');
                return;
            }

            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: 'static'
            });

            var formData = $(this).serialize();
            // console.log(formData);
            //return;
            // return;
            $.ajax({
                url: 'ajax/add_vendor.php', // your backend processing script
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {

                    $('#myLoading').modal('hide');
                    if (response.success) {
                        // console.log(response);
                        $('#succPan').html(response.message).show();
                        fadeInFadeOut($('#succPan'));
                    } else {
                        // console.log("lower", response.success);
                        $('#errPan').html(response.message).show();
                        fadeInFadeOut($('#errPan'));
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // console.log("AJAX error");
                    // console.log("Status:", textStatus);
                    // console.log("Error thrown:", errorThrown);
                    // console.log("Raw response text:", jqXHR.responseText);
                    $('#myLoading').modal('hide');
                    $('#errPan').text('Cannot contact server. Please try again later.').show();
                    fadeInFadeOut($('#errPan'));
                }
            });
        });
    });
</script>


<?PHP
include_once 'includes/footer_end.php';
