<?PHP 
$page = "Manage Support Tickets";
$page_url="ad_tickets";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php'; 
    
if ( isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101) ) : 
?>  
   <script> window.location.href = 'dash'; </script>
<?PHP
    exit();
endif;

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);
$tck = new Tickets($db, $ad);
$username = $_SESSION[$sid.'username'];
$deptid = 0;

include_once 'includes/accesschk.php'; 
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Support Tickets
        <small>online support tickets.</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Support Tickets</li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Support Tickets</h3>
                </div>
                <div class="box-body">
                    
                  <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs"> 
                        <li class="active"><a href="#allTickets" data-toggle="tab">All Tickets</a></li>
                        <li><a href="#deptTickets" data-toggle="tab">My Department's Tickets</a></li>
                        <li><a href="#openTickets" data-toggle="tab">Opened Tickets</a></li>
                        <li><a href="#closeTickets" data-toggle="tab">Closed Tickets</a></li>
                    </ul>
                    <div class="tab-content">
                      <div class="tab-pane active" id="allTickets">
                          <h3>All Tickets
                                <small>list of all support tickets</small>
                            </h3>
                            <p><strong>Important:</strong> The table below contains your most recent tickets and shows their subject. 
            Please write your comments regarding a certain issue in one ticket only.  </p>

<p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        $mytcks = $tck->getTicketList();
                        if (isset($mytcks)):
                            $cter = 0;
                            foreach ($mytcks as $key => $mytck) :
                            /*
                             * $ret[$row->TCK_ID] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
                             */
                                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $mytck["CONTENT"], $phrase);
                                if ($mytck["STATUS"] == "Needs Assistance"):
                                    $lblcolor = "label-info";
                                elseif ($mytck["STATUS"] == "Assistance Received"):
                                    $lblcolor = "label-success";
                                elseif ($mytck["STATUS"] == "Closed"):
                                    $lblcolor = "label-warning";
                                endif;
                                $rand = new Password_Generator();
                                $coded = base64_encode($mytck["TICKETID"]);
                                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                        ?>
                        <tr style="font-size:0.7em;">
                            <!--<td><?PHP echo ++$cter; ?></td>-->
                            <td class='center' style='text-align: center !important;'><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo $mytck["TICKETID"]; ?></a></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo date("d M, Y H:i:s a", strtotime($mytck["DATE_CREATED"])); ?></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo $mytck["USERNAME"]; ?></td>
                            <td><?PHP echo $mytck["DEPT"]; ?></td>
                            <td><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo "<strong>".$mytck["TITLE"]."</strong><br/>{$phrase[0]} ..."; ?></a></td>
                            <td class='center' style='text-align: center !important;font-size:1.3em !important;'><span class="label-default label <?PHP echo $lblcolor; ?>"><?PHP echo $mytck["STATUS"]; ?></span></td>
                            <td class='center' style='text-align: center !important;'></td>
                        </tr>
                        <?PHP
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                    <tfoot>
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tfoot>
                    
                </table>

                      </div>
                      <!-- /.tab-pane -->
                      
                      <div class="tab-pane" id="deptTickets">
                          <h3>My Departmental Tickets
                                <small>list of all my departmental support tickets</small>
                            </h3>
                            <p><strong>Important:</strong> The table below contains your most recent tickets and shows their subject. 
            Please write your comments regarding a certain issue in one ticket only.  </p>

<p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        $mytcks = $tck->getTicketList("", $deptid);
                        if (isset($mytcks)):
                            $cter = 0;
                            foreach ($mytcks as $key => $mytck) :
                            /*
                             * $ret[$row->TCK_ID] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
                             */
                                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $mytck["CONTENT"], $phrase);
                                if ($mytck["STATUS"] == "Needs Assistance"):
                                    $lblcolor = "label-info";
                                elseif ($mytck["STATUS"] == "Assistance Received"):
                                    $lblcolor = "label-success";
                                elseif ($mytck["STATUS"] == "Closed"):
                                    $lblcolor = "label-warning";
                                endif;
                                $rand = new Password_Generator();
                                $coded = base64_encode($mytck["TICKETID"]);
                                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                        ?>
                        <tr style="font-size:0.7em;">
                            <!--<td><?PHP echo ++$cter; ?></td>-->
                            <td class='center' style='text-align: center !important;'><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo $mytck["TICKETID"]; ?></a></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo date("d M, Y H:i:s a", strtotime($mytck["DATE_CREATED"])); ?></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo $mytck["USERNAME"]; ?></td>
                            <td><?PHP echo $mytck["DEPT"]; ?></td>
                            <td><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo "<strong>".$mytck["TITLE"]."</strong><br/>{$phrase[0]} ..."; ?></a></td>
                            <td class='center' style='text-align: center !important;font-size:1.3em !important;'><span class="label-default label <?PHP echo $lblcolor; ?>"><?PHP echo $mytck["STATUS"]; ?></span></td>
                            <td class='center' style='text-align: center !important;'></td>
                        </tr>
                        <?PHP
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                    <tfoot>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </tfoot>
                    
                </table>

                      </div>
                      <!-- /.tab-pane -->
                      
                      <!-- Opened Tickets -->
                        <div class="tab-pane " id="openTickets">
                            <h3>Open Tickets
                                <small>list of open support tickets</small>
                            </h3>
                            <p><strong>Important:</strong> The table below contains your most recent tickets and shows their subject. 
            Please write your comments regarding a certain issue in one ticket only.  </p>

<p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        $mytcks = $tck->getTicketList("", $deptid, 0);
                        if (isset($mytcks)):
                            $cter = 0;
                            foreach ($mytcks as $key => $mytck) :
                            /*
                             * $ret[$row->TCK_ID] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
                             */
                                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $mytck["CONTENT"], $phrase);
                                if ($mytck["STATUS"] == "Needs Assistance"):
                                    $lblcolor = "label-info";
                                elseif ($mytck["STATUS"] == "Assistance Received"):
                                    $lblcolor = "label-success";
                                elseif ($mytck["STATUS"] == "Closed"):
                                    $lblcolor = "label-warning";
                                endif;
                                $rand = new Password_Generator();
                                $coded = base64_encode($mytck["TICKETID"]);
                                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                        ?>
                        <tr style="font-size:0.7em;">
                            <!--<td><?PHP echo ++$cter; ?></td>-->
                            <td class='center' style='text-align: center !important;'><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo $mytck["TICKETID"]; ?></a></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo date("d M, Y H:i:s a", strtotime($mytck["DATE_CREATED"])); ?></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo $mytck["USERNAME"]; ?></td>
                            <td><?PHP echo $mytck["DEPT"]; ?></td>
                            <td><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo "<strong>".$mytck["TITLE"]."</strong><br/>{$phrase[0]} ..."; ?></a></td>
                            <td class='center' style='text-align: center !important;font-size:1.3em !important;'><span class="label-default label <?PHP echo $lblcolor; ?>"><?PHP echo $mytck["STATUS"]; ?></span></td>
                            <td class='center' style='text-align: center !important;'></td>
                        </tr>
                        <?PHP
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                    <tfoot>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </tfoot>
                    
                </table>

                        </div>
                        
                        <!-- Closed Tickets -->
                        <div class="tab-pane " id="closeTickets">
                            <h3>Closed Tickets
                                <small>list of closed support tickets</small>
                            </h3>
                            <p><strong>Important:</strong> The table below contains your most recent tickets and shows their subject. 
            Please write your comments regarding a certain issue in one ticket only.  </p>

<p>To continue the communication in a previously opened ticket, simply click on the ticket number or subject in the table below.</p>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        $mytcks = $tck->getTicketList("", $deptid, 1);
                        if (isset($mytcks)):
                            $cter = 0;
                            foreach ($mytcks as $key => $mytck) :
                            /*
                             * $ret[$row->TCK_ID] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
                             */
                                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $mytck["CONTENT"], $phrase);
                                if ($mytck["STATUS"] == "Needs Assistance"):
                                    $lblcolor = "label-info";
                                elseif ($mytck["STATUS"] == "Assistance Received"):
                                    $lblcolor = "label-success";
                                elseif ($mytck["STATUS"] == "Closed"):
                                    $lblcolor = "label-warning";
                                endif;
                                $rand = new Password_Generator();
                                $coded = base64_encode($mytck["TICKETID"]);
                                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                        ?>
                        <tr style="font-size:0.7em;">
                            <!--<td><?PHP echo ++$cter; ?></td>-->
                            <td class='center' style='text-align: center !important;'><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo $mytck["TICKETID"]; ?></a></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo date("d M, Y H:i:s a", strtotime($mytck["DATE_CREATED"])); ?></td>
                            <td class='center' style='text-align: center !important; '><?PHP echo $mytck["USERNAME"]; ?></td>
                            <td><?PHP echo $mytck["DEPT"]; ?></td>
                            <td><a href="ad_vtick/<?PHP echo $coded; ?>"><?PHP echo "<strong>".$mytck["TITLE"]."</strong><br/>{$phrase[0]} ..."; ?></a></td>
                            <td class='center' style='text-align: center !important;font-size:1.3em !important;'><span class="label-default label <?PHP echo $lblcolor; ?>"><?PHP echo $mytck["STATUS"]; ?></span></td>
                            <td class='center' style='text-align: center !important;'></td>
                        </tr>
                        <?PHP
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                    <tfoot>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>TICKET ID</th>
                        <th style='text-align: center !important;'>DATE OPENED</th>
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>DEPT.</th>
                        <th style='text-align: center !important; width: 30%'>SUBJECT</th>
                        <th style='text-align: center !important;'>STATUS</th>
                        <th style='text-align: center !important;'>ACTION</th>
                    </tr>
                    </tfoot>
                    
                </table>

                        </div>
                      
                    </div>
                    <!-- /.tab-content -->
                      
                  </div>
                  <!-- /.nav-tabs-custom -->
                    
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-12 -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script type="text/javascript">
   $(document).ready(function () {

        
        $('.dataTable').DataTable({
//            "dom": "<'row'<'col-md-6'l><'col-md-6'f>r>t<'row'<'col-md-12'i><'col-md-12 center-block'p>>",
//            'paging'      : true,
//            'lengthChange': false,
//            'searching'   : true,
            'ordering'    : true,
//            'info'        : true,
            deferRender: true,
//            columnDefs: [ {
//                orderable: false,
//                className: 'select-checkbox',
//                targets:   0
//            } ],            
//            select: {
//                style:    'os',
//                selector: 'td:first-child'
//            },
            order: [[ 0, 'desc' ]],
//            columns: [
//                { data: 'username' },
//                { data: 'service_id' },
//                { data: 'service' },
//                { data: 'type' },
//                { data: 'amount' },
//                { data: 'expiration' },
//                { data: 'status' },
//                { data: 'action' }
//            ],
//            select: true,
            'autoWidth'   : false,
            "aLengthMenu": [ [50, 100, 200, -1], [50, 100, 200, "All"] ],
            "iDisplayLength": 50,
            fixedHeader: true,
//            dom: 'Bfrtip',
//            buttons: [
//                'copyHtml5',
//                'pdfHtml5',
//                'excelHtml5',
//                'print',
//                'pageLength'
//            ]
            dom: 'B<"clear"><"clear">lfrtip',
//            ajax: '/api/data',
            buttons: {
                name: 'primary',
                buttons: [ 'copy', 'csv', 'excel', 'print', 'pdf', 'colvis', {
                        text: 'Reload',
                        action: function ( e, dt, node, config ) {
                            dt.ajax.reload();
                        }
                    } ]
            }
        });
   });   
</script>
<?PHP include_once 'includes/footer_end.php';