<?PHP
$page = "Advert Banner Management";
$page_url = "ad_adverts";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$plans = $ad->loadPlans(-1, 0, 1);

if ($_SESSION[$sid . 'readonly']) {
    echo "alert('You only have readonly access. Contact Administrator if you think this is by error.');";
    echo "<script> window.location.href = 'ad_listsrv'; </script>";
    exit();
}

//include_once 'includes/accesschk.php';
?>

<style>
    .form-horizontal .form-group {
        margin-bottom: 0px !important;
        margin-right: 0px !important;
        margin-left: 0px !important;
    }

    #drop-area {
        margin-top:20px;
        margin-left:220px;
        width: 90%; /*250px;*/
        height:100px;
        background-color:white;
        border:3px dashed grey;
    }
    .drop-text {
        margin-top:45px;
        color:grey;
        font-size:25px;
        font-weight:bold;
    }
    #drop-area img  {
        max-width:200px;
    }
    
    #img-preview-div {
        text-align: center;
    }
    
    .img-preview-container {
        min-height: 425px;
    }
    
    .dz-message {
        padding: 40px 70px;
        border: 2px dashed lightgray;
    }
</style>
<link rel="stylesheet" href="dist/dropzone/dropzone.min.css">
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Advert Banner Management
        <small>Kindly fill the form as required below .</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Advert banner Management</li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-6">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Add New Advert Banner </h3>
                </div>
                <div class="box-body">
                    <small><strong>Kindly fill the form as required below.</strong></small>
                    <hr />
                     <div class="alert alert-danger" id="errPan" style="display: none" ></div>
                    <div class="alert alert-success" id="succPan" style="display: none" ></div>
                    
                    <form data-toggle="validator" class="dropzone" id="my-awesome-dropzone" name="cuser_form" action="ajax/ad_adverts_upload" method="post">
                        <fieldset>
                            <input type="hidden" name="user" id="user" value="<?PHP echo $_SESSION[$sid.'username']; ?>" />
                            <input type="hidden" name="userid" id="userid" value="<?PHP echo $_SESSION[$sid.'userid']; ?>" />
                            
                            <div class="form-group has-feedback">
                                <span class="input-group-addon">Ad Content URL:</span>
                                <input type="text" class="form-control" name="adContentUrl" id="adContentUrl" value="" placeholder="Ads Content URL"  />
                            </div>                       

                            <p class="center col-md-12 button-p">
                                <button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-lock green"></i> Add Banner</button>
                            </p>
                            
                        </fieldset>
                        
                        
                    </form>
                    
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-6 -->
            
            <div class="col-md-6">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Preview </h3>
                </div>
                
                <div class="box-body img-preview-container">
                    <div id="img-preview-div" class="dropzone-previews previews">
                        <!--<img id="img-preview" src="src" width="90%"  alt="image preview"/>-->
                    </div>
                </div>
                  
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-6 -->
            
        </div>
        
    </section>
    <!-- /.Main content -->
    
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Advert Banner List</h3>
                </div>
                <div class="box-body">
                    <h3>Advert Banner
                          <small>list of advert banners</small>
                    </h3>
                    <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                        <thead>
                          <tr>
                              <th>SN</th>
                              <th class='center' style='text-align: center !important;'>AD BANNER</th> 
                              <th class='center' style='text-align: center !important;'>FILENAME</th> 
                              <th class='center' style='text-align: center !important;'>CONTENT URL</th> 
                              <th style='text-align: center !important;'>STATUS</th>
                              <th style='text-align: center !important;'>ADDED BY</th> 
                              <th style='text-align: center !important;'>DATE ADDED</th> 
                              <th style='text-align: center !important;'>ACTION</th>     
                          </tr>
                        </thead>

                        <tfoot>
                          <tr>
                              <th>SN</th>
                              <th class='center' style='text-align: center !important;'>AD BANNER</th> 
                              <th class='center' style='text-align: center !important;'>FILENAME</th> 
                              <th class='center' style='text-align: center !important;'>CONTENT URL</th> 
                              <th style='text-align: center !important;'>STATUS</th>
                              <th style='text-align: center !important;'>ADDED BY</th> 
                              <th style='text-align: center !important;'>DATE ADDED</th> 
                              <th style='text-align: center !important;'>ACTION</th> 
                          </tr>
                        </tfoot>
                    </table>

                </div>
              </div>
            </div>
            <!-- /.col-md-12 -->
            
        </div>
        <!-- /.row -->
    </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
                
<script src="dist/dropzone/dropzone.min.js"></script>
<script type="text/javascript">
$(document).ready(function () {
    // Show an element and then fade it out with the timeout given
    var fadeInFadeOut = function(jQueryElement, timeout) {
    jQueryElement.fadeIn(1000);
    setTimeout(function() { jQueryElement.fadeOut("slow"); }, timeout);
    };
    
    $("table").on("click", "a.gFormDel", function(){ 

         var bannerId = $(this).data("val"); 
         var newState = $(this).data("newstate"); 
//         alert("ID:" + bannerId + " || State:" + newState);
         if (confirm("Are you sure you want to set Banner with ID ("+ bannerId + ") to Status - " +newState+"?") === true) {
             $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: "static"
              });
            var dat = "bannerId="+bannerId+"&newState="+newState;
           
          
            $.ajax({
              type: "POST",
              url: "ajax/setAdvert.php",
              data: dat,
              dataType: "text",
              success: function(response){  //alert(response);
                  if(response.match(/Success/i)) { //
                      alert(response);
                      $('#myLoading').modal("hide");                                   
                      $('div#succPan').html(response);
                      
                      table.draw();

                   }  else {
                       alert(response);
                      $('#myLoading').modal("hide");
                      $('div#errPan').html(response);
                      fadeInFadeOut($("div#errPan"), 5000);
                   }
              },
              error: function(xhr, error) {
                  $('#myLoading').modal("hide");
                  $('div#errPan').text("Sorry, cannot contact server at this time. Please try again later!" + xhr + " :: " + error);
                  fadeInFadeOut($("div#errPan"), 5000);
                  console.debug(xhr); console.debug(error);
              }
            });
        
         }

//         var rowId = $('#acctable').dataTable()
//                     .fnFindCellRowIndexes(user, 1);
    });
    
//    $("div#myId").dropzone({ url: "/file/post" });  

       /* For Export Buttons available inside jquery-datatable "server side processing" - Start
- due to "server side processing" jquery datatble doesn't support all data to be exported
- below function makes the datatable to export all records when "server side processing" is on */

function newexportaction(e, dt, button, config) { 
	alert("Pulling data from DB, download will commence once data is pulled. This may take 1-3mins depending on the volume of data");
    var self = this;
    var oldStart = dt.settings()[0]._iDisplayStart;
    dt.one('preXhr', function (e, s, data) {
        // Just this once, load all data from the server...
        data.start = 0;
        data.length = 2147483647;
        dt.one('preDraw', function (e, settings) {
            // Call the original action function
            if (button[0].className.indexOf('buttons-copy') >= 0) {
                $.fn.dataTable.ext.buttons.copyHtml5.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-excel') >= 0) {
                $.fn.dataTable.ext.buttons.excelHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.excelHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.excelFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-csv') >= 0) {
                $.fn.dataTable.ext.buttons.csvHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.csvHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.csvFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-pdf') >= 0) {
                $.fn.dataTable.ext.buttons.pdfHtml5.available(dt, config) ?
                    $.fn.dataTable.ext.buttons.pdfHtml5.action.call(self, e, dt, button, config) :
                    $.fn.dataTable.ext.buttons.pdfFlash.action.call(self, e, dt, button, config);
            } else if (button[0].className.indexOf('buttons-print') >= 0) {
                $.fn.dataTable.ext.buttons.print.action(e, dt, button, config);
            }
            dt.one('preXhr', function (e, s, data) {
                // DataTables thinks the first item displayed is index 0, but we're not drawing that.
                // Set the property to what it was before exporting.
                settings._iDisplayStart = oldStart;
                data.start = oldStart;
            });
            // Reload the grid with the original page. Otherwise, API functions like table.cell(this) don't work properly.
            setTimeout(dt.ajax.reload, 0);
            // Prevent rendering of the full data to the DOM
            return false;
        });
    });
    // Requery the server with the new one-time export settings
    dt.ajax.reload();
};
//For Export Buttons available inside jquery-datatable "server side processing" - End

    var table = $('#acctable').DataTable({
        'ordering'    : true,
        deferRender: true,
        'autoWidth'   : false,
        "aLengthMenu": [ [50, 100, 200, 500, 1000, 1500, 2000, 5000, -1], [50, 100, 200, 500, 1000, 1500, 2000, 5000, "All"] ],
        "iDisplayLength": 50,
        fixedHeader: true,
        "order": [[ 6, "desc" ]],
        "processing": true,
        "serverSide": true,
        "bSortClasses": false,
        'scrollX': true,
        'serverMethod': 'post',

        dom: 'B<"clear"><"clear">lfrtip',
        ajax: 'ajax/getAdBanners',
             'columns': [
                { data: 'SN' }, 
                { data: 'AD_BANNER' },
                { data: 'AD_IMG' },
                { data: 'AD_CONTENT_URL' },
                { data: 'STATUS' }, 
                { data: 'FULLNAME' },
                { data: 'DATEADDED' },
                { data: 'ACTION' },
             ],
        buttons: {
                name: 'primary',
                "buttons": [{
                    "extend": 'copy',
                    "text": '<i class="fa fa-files-o" style="color: green;"></i> Copy',
                    "titleAttr": 'Copy',                               
                    "action": newexportaction
                 },
                 {
                    "extend": 'excel',
                    "text": '<i class="fa fa-file-excel-o" style="color: green;"></i> Excel',
                    "titleAttr": 'Excel',                               
                    "action": newexportaction
                 },
                 {
                    "extend": 'csv',
                    "text": '<i class="fa fa-file-excel-o" style="color: green;"></i> CSV',
                    "titleAttr": 'CSV',                               
                    "action": newexportaction
                 },
                 {
                    "extend": 'pdf',
                    "text": '<i class="fa fa-file-pdf-o" style="color: red;"></i> PDF',
                    "titleAttr": 'PDF',                               
                    "action": newexportaction
                 }, 'colvis', {
                             text: 'Reload',
                             action: function ( e, dt, node, config ) {
                                 dt.ajax.reload();
                             }
                 },
                 {
                    "extend": 'print',
                    "text": '<i class="fa fa-print" style="color: blue;"></i> Print',
                    "titleAttr": 'Print',                                
                    "action": newexportaction
                 }],
        }
    });

    
    
    $( "div.dz-message" ).insertBefore( $( ".button-p" ) );
    
});
    Dropzone.options.myAwesomeDropzone = { // The camelized version of the ID of the form element

        // The configuration we've talked about above
//        url: 'ajax/ad_adverts_upload',
        autoProcessQueue: false,
        uploadMultiple: false,
        parallelUploads: 100,
        maxFiles: 100,
        thumbnailMethod: "contain",
        thumbnailWidth: 500,
        acceptedFiles: 'image/*',
        previewsContainer: '.dropzone-previews',
        dictDefaultMessage: "Drop Ad Banner file here to upload",

        // The setting up of the dropzone
        init: function() {
          var myDropzone = this;

          // First change the button to actually tell Dropzone to process the queue.
          this.element.querySelector("button[type=submit]").addEventListener("click", function(e) {
            // Make sure that the form isn't actually being sent.
            e.preventDefault();
            e.stopPropagation();
            myDropzone.processQueue();
          });

          // Listen to the sendingmultiple event. In this case, it's the sendingmultiple event instead
          // of the sending event because uploadMultiple is set to true.
          this.on("sendingmultiple", function() {
            // Gets triggered when the form is actually being sent.
            // Hide the success button or the complete form.
          });
          this.on("successmultiple", function(files, response) {
            // Gets triggered when the files have successfully been sent.
            // Redirect user or notify of success.
            $('div#succPan').html(response);
            fadeInFadeOut($("div#succPan"), 5000);
            $('form[name="cuser_form"]')[0].reset();
          });
          this.on("errormultiple", function(files, response) {
            // Gets triggered when there was an error sending the files.
            // Maybe show form again, and notify user of error
            $('div#errPan').html(response);
            fadeInFadeOut($("div#errPan"), 5000);
          });
          
          
        }

    }
  
</script>