<?PHP
$page = "New Customer Registration";
$page_url = "New_Registration_old";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';



//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$all_products = $dashboard->getAllProductsSalesAdmin();

$products = [
    ['id' => 1, 'name' => 'Premium Max+ Plan', 'price' => 45231.89],
    ['id' => 2, 'name' => 'Installation', 'price' => 45231.89],
    ['id' => 3, 'name' => 'Battery Pack', 'price' => 45231.89],
];



?>

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            Add Customer Order
            <small>Create order on behalf of customer</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Add Customer Order</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Customer & Order Information</h3>
            </div>

            <div class="alert alert-danger" id="errPan" style="display:none"></div>
            <div class="alert alert-success" id="succPan" style="display:none"></div>

            <form id="addCustomerOrderForm">
                <div class="box-body">

                    <!-- Full Name -->
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" class="form-control" name="name"
                            value="<?= htmlspecialchars($customer['name'] ?? '') ?>" required>
                    </div>

                    <!-- Company Name -->
                    <div class="form-group">
                        <label for="company_name">Company Name</label>
                        <input type="text" id="company_name" class="form-control" name="company_name"
                            value="<?= htmlspecialchars($customer['company_name'] ?? '') ?>">
                    </div>

                    <!-- Email -->
                    <div class="form-group">
                        <label for="email">Email *</label>
                        <input type="email" id="email" class="form-control" name="email"
                            value="<?= htmlspecialchars($customer['email'] ?? '') ?>" required>
                    </div>

                    <!-- Phone -->
                    <div class="form-group">
                        <label for="phone">Phone *</label>
                        <input type="text" id="phone" class="form-control" name="phone"
                            value="<?= htmlspecialchars($customer['phone'] ?? '') ?>" required>
                    </div>

                    <!-- Address -->
                    <div class="form-group">
                        <label for="address">Full Address</label>
                        <textarea id="address" class="form-control" name="address"
                            rows="2"><?= htmlspecialchars($customer['address'] ?? '') ?></textarea>
                    </div>

                    <!-- How did you hear about us -->
                    <div class="form-group">
                        <label for="source">How did you hear about us?</label>
                        <select id="source" name="source" class="form-control">
                            <option value="">-- Select --</option>
                            <option value="social" <?= (!empty($customer['source']) && $customer['source'] == 'social') ? 'selected' : '' ?>>Social Media</option>
                            <option value="referral" <?= (!empty($customer['source']) && $customer['source'] == 'referral') ? 'selected' : '' ?>>Referral</option>
                            <option value="ads" <?= (!empty($customer['source']) && $customer['source'] == 'ads') ? 'selected' : '' ?>>Ads</option>
                            <option value="other" <?= (!empty($customer['source']) && $customer['source'] == 'other') ? 'selected' : '' ?>>Other</option>
                        </select>
                    </div>

                    <!-- Comment -->
                    <div class="form-group">
                        <label for="comment">Any comment</label>
                        <textarea id="comment" class="form-control" name="comment"
                            rows="2"><?= htmlspecialchars($customer['comment'] ?? '') ?></textarea>
                    </div>


                    <hr>
                    <h4>Order Products</h4>
                    <div class="form-group">
                        <?php foreach ($products as $p): ?>
                            <div class="checkbox"
                                style="margin-bottom:10px; border:1px solid #ddd; padding:10px; border-radius:5px;">
                                <label style="display:flex; justify-content:space-between; width:100%;">
                                    <div>
                                        <input type="checkbox" name="products[]" value="<?= $p['id'] ?>">
                                        <?= htmlspecialchars($p['name']) ?>
                                    </div>
                                    <span><strong>₦<?= number_format($p['price'], 2) ?></strong></span>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>


                </div>

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">
                        Create Order & Generate Link
                    </button>
                </div>
            </form>
        </div>
        <h2>FOB Products</h2>
        <?php if (!empty($all_products['fob'])): ?>
            <ul>
                <?php foreach ($all_products['fob'] as $product): ?>
                    <li>
                        <?= htmlspecialchars($product->name) ?> -
                        N<?= number_format($product->price, 2) ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p>No FOB products available.</p>
        <?php endif; ?>

        <h2>Third Party Vendor Products</h2>
        <?php if (!empty($all_products['third_party'])): ?>
            <ul>
                <?php foreach ($all_products['third_party'] as $product): ?>
                    <li>
                        <?= htmlspecialchars($product->name) ?> -
                        N<?= number_format($product->price, 2) ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p>No third-party products available.</p>
        <?php endif; ?>

    </section>
</div>


<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>
<script>
    $(document).ready(function () {
        var fadeInFadeOut = function (jQueryElement, timeout) {
            jQueryElement.fadeIn(1000);
            // setTimeout(function() {
            //     jQueryElement.fadeOut("slow");
            // }, timeout);
        };
        var Base64 = {
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
            encode: function (e) {
                var t = "";
                var n, r, i, s, o, u, a;
                var f = 0;
                e = Base64._utf8_encode(e);
                while (f < e.length) {
                    n = e.charCodeAt(f++);
                    r = e.charCodeAt(f++);
                    i = e.charCodeAt(f++);
                    s = n >> 2;
                    o = (n & 3) << 4 | r >> 4;
                    u = (r & 15) << 2 | i >> 6;
                    a = i & 63;
                    if (isNaN(r)) {
                        u = a = 64
                    } else if (isNaN(i)) {
                        a = 64
                    }
                    t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
                }
                return t
            },
            decode: function (e) {
                var t = "";
                var n, r, i;
                var s, o, u, a;
                var f = 0;
                e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "");
                while (f < e.length) {
                    s = this._keyStr.indexOf(e.charAt(f++));
                    o = this._keyStr.indexOf(e.charAt(f++));
                    u = this._keyStr.indexOf(e.charAt(f++));
                    a = this._keyStr.indexOf(e.charAt(f++));
                    n = s << 2 | o >> 4;
                    r = (o & 15) << 4 | u >> 2;
                    i = (u & 3) << 6 | a;
                    t = t + String.fromCharCode(n);
                    if (u != 64) {
                        t = t + String.fromCharCode(r)
                    }
                    if (a != 64) {
                        t = t + String.fromCharCode(i)
                    }
                }
                t = Base64._utf8_decode(t);
                return t
            },
            _utf8_encode: function (e) {
                e = e.replace(/\r\n/g, "\n");
                var t = "";
                for (var n = 0; n < e.length; n++) {
                    var r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r)
                    } else if (r > 127 && r < 2048) {
                        t += String.fromCharCode(r >> 6 | 192);
                        t += String.fromCharCode(r & 63 | 128)
                    } else {
                        t += String.fromCharCode(r >> 12 | 224);
                        t += String.fromCharCode(r >> 6 & 63 | 128);
                        t += String.fromCharCode(r & 63 | 128)
                    }
                }
                return t
            },
            _utf8_decode: function (e) {
                var t = "";
                var n = 0;
                var r = c1 = c2 = 0;
                while (n < e.length) {
                    r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r);
                        n++
                    } else if (r > 191 && r < 224) {
                        c2 = e.charCodeAt(n + 1);
                        t += String.fromCharCode((r & 31) << 6 | c2 & 63);
                        n += 2
                    } else {
                        c2 = e.charCodeAt(n + 1);
                        c3 = e.charCodeAt(n + 2);
                        t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
                        n += 3
                    }
                }
                return t
            }
        }
        $('#addCustomerOrderForm').validator().on('submit', function (e) {
            e.preventDefault();

            $('#succPan, #errPan').hide().empty();

            var name = $('#name').val().trim();
            var email = $('#email').val().trim();
            var phone = $('#phone').val().trim();
            var address = $('#address').val().trim();
            var companyName = $('#company_name').val().trim();
            var products = $('input[name="products[]"]:checked');

            // Validate fields
            if (!name) {
                alert('Full Name is required.');
                return;
            }
            if (!email) {
                alert('Email is required.');
                return;
            }
            if (!phone) {
                alert('Phone number is required.');
                return;
            }
            if (!address) {
                alert('Full Address is required.');
                return;
            }
            if (!companyName) {
                alert('Company Name is required.');
                return;
            }
            if (products.length === 0) {
                alert('Please select at least one product.');
                return;
            }

            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: 'static'
            });

            var formData = $(this).serialize();
            console.log(formData);
            console.log(decodeURIComponent(formData));

            //return;
            // return;
            $.ajax({
                url: 'ajax/add_customer_order.php', // your backend processing script
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function (response) {
                    console.log(response);
                    $('#myLoading').modal('hide');
                    if (response.success) {
                        console.log(response);
                        $('#succPan').html(response.message).show();
                        fadeInFadeOut($('#succPan'));
                    } else {
                        console.log("lower", response);
                        $('#errPan').html(response.message).show();
                        fadeInFadeOut($('#errPan'));
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log("AJAX error");
                    console.log("Status:", textStatus);
                    console.log("Error thrown:", errorThrown);
                    console.log("Raw response text:", jqXHR.responseText);
                    $('#myLoading').modal('hide');
                    $('#errPan').text('Cannot contact server. Please try again later.').show();
                    fadeInFadeOut($('#errPan'));
                }
            });
        });
    });
</script>


<?PHP
include_once 'includes/footer_end.php';
